<?php
/***************************************************************************
 *                                album.php
 *                            -------------------
 *   begin                : Tuesday, February 04, 2003
 *   copyright            : (C) 2003 Smartor
 *   email                : smartor_xp@hotmail.com
 *
 *   $Id: album.php,v 2.0.7 2003/03/15 10:16:30 ngoctu Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 *                            MODIFICATIONS
 *                           ---------------
 *   started            : Saturday, January 18, 2004
 *   copyright          :  Volodymyr (CLowN) Skoryk
 *   email              : blaatimmy72@yahoo.com
 *	 version            : 1.5
 *
 *	 MODIFICATIONS:
 *		-added images to rating, insted of number for rating
 *		-added random pictures
 *		-added highest rated pictures (@ MarkFulton.com)
 *		-coment # for categories
 *		-last comment in categories
 *
 ***************************************************************************/

/***************************************************************************
 *                            MODIFICATIONS
 *                           ---------------
 *     copyright            : (C) 2004 IdleVoid
 *     email                : idlevoid@slater.dk
 *     file version         : 1.0.8
 *     release              : 1.3.0
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.' . $phpEx);

// Start session management
$userdata = session_pagestart($user_ip, PAGE_ALBUM);
init_userprefs($userdata);
// End session management

// Get general album information
$album_root_path = $phpbb_root_path . ALBUM_MOD_PATH . '';
include($album_root_path . 'album_common.' . $phpEx);

// ------------------------------------
// Check $album_user_id
// ------------------------------------
if (isset ($_POST['user_id']))
{
	$album_user_id = intval($_POST['user_id']);
}
elseif (isset ($_GET['user_id']))
{
	$album_user_id = intval($_GET['user_id']);
}
else
{
	// if no user_id was supplied then we aren't going to show a personal gallery category
	$album_user_id = ALBUM_PUBLIC_GALLERY;
}

if ($album_user_id != ALBUM_PUBLIC_GALLERY)
{
	$cat_id = ALBUM_ROOT_CATEGORY;

	if (isset ($_POST['mode']))
	{
		$album_view_mode = strtolower($_POST['mode']);
	}
	elseif (isset ($_GET['mode']))
	{
		$album_view_mode = strtolower($_GET['mode']);
	}
	// make sure that it only contains some valid value
	switch ($album_view_mode)
	{
		case ALBUM_VIEW_ALL:
			$album_view_mode = ALBUM_VIEW_ALL;
			break;
		case ALBUM_VIEW_LIST:
			$album_view_mode = ALBUM_VIEW_LIST;
			break;
		default:
			$album_view_mode = '';
	}

	if (isset ($_POST['cat_id']))
	{
		$cat_id = intval($_POST['cat_id']);
	}
	elseif (isset ($_GET['cat_id']))
	{
		$cat_id = intval($_GET['cat_id']);
	}

	if ($album_user_id < 1)
	{
		if (!$userdata['session_logged_in'])
		{
			redirect(append_sid(album_append_uid(LOGIN_MG . "?redirect=album.$phpEx", true)));
		}
		else
		{
			$album_user_id = $userdata['user_id'];
			redirect(append_sid(album_append_uid("album.$phpEx", true)));
		}
	}

	if ($cat_id != ALBUM_ROOT_CATEGORY && $cat_id != album_get_personal_root_id($album_user_id))
	{
		redirect(append_sid(album_append_uid("album_cat.$phpEx" . album_build_url_parameters($_GET), false)));
	}
}

$catrows = array ();
$options = ($album_view_mode == ALBUM_VIEW_LIST ) ? ALBUM_READ_ALL_CATEGORIES|ALBUM_AUTH_VIEW : ALBUM_AUTH_VIEW;
$catrows = album_read_tree($album_user_id, $options);

album_read_tree($album_user_id);
$album_nav_cat_desc = album_make_nav_tree($cat_id, "album_cat.$phpEx", "nav" , $album_user_id);
if ($album_nav_cat_desc != '')
{
	$album_nav_cat_desc = ALBUM_NAV_ARROW . $album_nav_cat_desc;
}
// --------------------------------
// Build allowed category-list (for recent pics after here)
// $catrows array now stores all categories which this user can view.
// --------------------------------
$allowed_cat = ''; // For Recent Public Pics below
for ($i = 0; $i < count($catrows); $i ++)
{
	// --------------------------------
	// build list of allowd category id's
	// --------------------------------
	$allowed_cat .= ($allowed_cat == '') ? $catrows[$i]['cat_id'] : ','.$catrows[$i]['cat_id'];
}
//
// END of Categories Index
//

// ------------------------------------
// Build the sort method and sort order
// information
// ------------------------------------

if (isset ($_GET['start']))
{
	$start = intval($_GET['start']);
}
elseif (isset ($_POST['start']))
{
	$start = intval($_POST['start']);
}
else
{
	$start = 0;
}

if (isset ($_GET['sort_method']))
{
	switch ($_GET['sort_method'])
	{
		case 'pic_time' :
			$sort_method = 'pic_time';
			break;
		case 'pic_title' :
			$sort_method = 'pic_title';
			break;
		case 'username' :
			$sort_method = 'username';
			break;
		case 'pic_view_count' :
			$sort_method = 'pic_view_count';
			break;
		case 'rating' :
			$sort_method = 'rating';
			break;
		case 'comments' :
			$sort_method = 'comments';
			break;
		case 'new_comment' :
			$sort_method = 'new_comment';
			break;
		default :
			$sort_method = $album_config['sort_method'];
	}
}
elseif (isset ($_POST['sort_method']))
{
	switch ($_POST['sort_method'])
	{
		case 'pic_time' :
			$sort_method = 'pic_time';
			break;
		case 'pic_title' :
			$sort_method = 'pic_title';
			break;
		case 'username' :
			$sort_method = 'username';
			break;
		case 'pic_view_count' :
			$sort_method = 'pic_view_count';
			break;
		case 'rating' :
			$sort_method = 'rating';
			break;
		case 'comments' :
			$sort_method = 'comments';
			break;
		case 'new_comment' :
			$sort_method = 'new_comment';
			break;
		default :
			$sort_method = $album_config['sort_method'];
	}
}
else
{
	$sort_method = $album_config['sort_method'];
}

if (isset ($_GET['sort_order']))
{
	switch ($_GET['sort_order'])
	{
		case 'ASC' :
			$sort_order = 'ASC';
			break;
		case 'DESC' :
			$sort_order = 'DESC';
			break;
		default :
			$sort_order = $album_config['sort_order'];
	}
}
elseif (isset ($_POST['sort_order']))
{
	switch ($_POST['sort_order'])
	{
		case 'ASC' :
			$sort_order = 'ASC';
			break;
		case 'DESC' :
			$sort_order = 'DESC';
			break;
		default :
			$sort_order = $album_config['sort_order'];
	}
}
else
{
	$sort_order = $album_config['sort_order'];
}

// ------------------------------------
// additional sorting options
// ------------------------------------
if ($album_user_id != ALBUM_PUBLIC_GALLERY)
{
	$sort_rating_option = '';
	$sort_comments_option = '';
	$sort_new_comment_option = '';

	if ($album_config['rate'] == 1)
	{
		$sort_rating_option = '<option value="rating" ';
		$sort_rating_option .= ($sort_method == 'rating') ? 'selected="selected"' : '';
		$sort_rating_option .= '>'.$lang['Rating'].'</option>';
	}
	if ($album_config['comment'] == 1)
	{
		$sort_comments_option = '<option value="comments" ';
		$sort_comments_option .= ($sort_method == 'comments') ? 'selected="selected"' : '';
		$sort_comments_option .= '>'.$lang['Comments'].'</option>';

		$sort_new_comment_option = '<option value="new_comment" ';
		$sort_new_comment_option .= ($sort_method == 'new_comment') ? 'selected="selected"' : '';
		$sort_new_comment_option .= '>'.$lang['New_Comment'].'</option>';
	}
}
// BEGIN Code to add the personal galleries to the album index page and cats - lefty74
// http://www.mightygorgon.com/viewtopic.php?p=27486#27486

$sql = "SELECT u.username, u.user_id, u.user_regdate, COUNT(p.pic_id) AS pics, MAX(p.pic_id) AS last_pic, MAX(p.pic_time) AS last_pictime, COUNT(c.cat_user_id) AS cats
		FROM ". USERS_TABLE ." AS u, " . ALBUM_TABLE . " AS p, " . ALBUM_CAT_TABLE . " AS c
		WHERE u.user_id <> ". ANONYMOUS ."
			AND c.cat_user_id = u.user_id
			AND c.cat_id = p.pic_cat_id
		GROUP BY user_id
		ORDER BY last_pictime DESC";

if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
}

$memberrow = array();

while( $row = $db->sql_fetchrow($result) )
{
	$memberrow[] = $row;
}

for ($i = 0; $i < count($memberrow); $i++)
{
	$template->assign_block_vars('memberrow', array(
		'ROW_CLASS' => ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'],
		'USERNAME' => $memberrow[$i]['username'],
		'U_VIEWGALLERY' => append_sid(album_append_uid("album.$phpEx?user_id=". $memberrow[$i]['user_id'])),
//		'JOINED' => create_date($lang['DATE_FORMAT'], $memberrow[$i]['user_regdate'], $board_config['board_timezone']),
		'JOINED' => create_date($lang['DATE_FORMAT'], $memberrow[$i]['last_pictime'], $board_config['board_timezone']),
		'PICS' => $memberrow[$i]['pics'])
		
	
);
	
	
}

$sql = "SELECT COUNT(DISTINCT u.user_id) AS total
		FROM ". USERS_TABLE ." AS u, ". ALBUM_TABLE ." AS p, " . ALBUM_CAT_TABLE . " AS c
		WHERE u.user_id <> ". ANONYMOUS ."
			AND c.cat_user_id = u.user_id
			AND c.cat_id = p.pic_cat_id";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error getting total galleries', '', __LINE__, __FILE__, $sql);
}
// END Code to add the personal galleries to the album index page. - lefty74

/*
+----------------------------------------------------------
| Start output the page
+----------------------------------------------------------
*/

$page_title = $lang['Album'];

// is it a public gallery ?
if ($album_user_id == ALBUM_PUBLIC_GALLERY)
{
	include($phpbb_root_path . 'includes/page_header.' . $phpEx);

	$template->set_filenames(array(
		'body' => 'album_index_body.tpl')
	);

	$cols = ($album_config['img_cols'] == 0 ? 4 : $album_config['img_cols']);
	$cols_width = (100 / $cols) . '%';

	// Last Comments
	if ($album_config['show_last_comments'] == 1)
	{
		album_build_last_comments_info($allowed_cat);
	}

	// Recent Public Pics
	if ($album_config['disp_late'] == 1)
	{
		album_build_recent_pics($allowed_cat);
	}

	// Highest Rated Pics
	if ($album_config['disp_high'] == 1)
	{
		album_build_highest_rated_pics($allowed_cat);
	}

	// Most Viewed Pics
	if ($album_config['disp_mostv'] == 1)
	{
		album_build_most_viewed_pics($allowed_cat);
	}

	//Random Pics
	if ($album_config['disp_rand'] == 1)
	{
		album_build_random_pics($allowed_cat);
	}

	
	$template->assign_vars(array(
		'ALBUM_NAV' => $album_nav_cat_desc,
		'S_COLS' => $cols,
		'S_COL_WIDTH' => $cols_width,
		'TARGET_BLANK' => ($album_config['fullpic_popup']) ? 'target="_blank"' : '',
		'L_RAND_PICS' => $lang['Random_Pictures'],
		'L_HI_RATINGS' => $lang['Highest_Rated_Pictures'],
		'L_RECENT_PUBLIC_PICS' => $lang['Recent_Public_Pics'],
		'L_MOST_VIEWED' => $lang['Most_Viewed_Pictures'],
		'L_NO_PICS' => $lang['No_Pics'],
		'L_PIC_TITLE' => $lang['Pic_Image'],
		'L_PIC_ID' => $lang['Pic_ID'],
		'L_VIEW' => $lang['View'],
		'L_POSTER' => $lang['Pic_Poster'],
		'L_POSTED' => $lang['Posted'],
// lefty74: BEGIN Added Personal Galleries on INdex and cats
		'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_ORDER' => $lang['Order'],
	'L_SORT' => $lang['Sort'],
	'L_LASTPIC' => $lang['Last_Pic'],	
	'L_PICS' => $lang['Pics'],
	'L_USERS_PERSONAL_GALLERIES' => $lang['Users_Personal_Galleries'],
// lefty74: END Added Personal Galleries on INdex and cats

		'L_ALBUM_ALLPICS' => $lang['All_Picture_List_Of_User'],
// lefty74: BEGIN changed the code so that only admin can see the text for the OTF		
		'L_ALBUM_OTF' => ( $userdata['user_level'] == ADMIN ) ? '&nbsp;&#8226;&nbsp;' . $lang['Pic_Gallery'] : '',
// lefty74: END changed the code so that only admin can see the text for the OTF		
		'U_ALBUM_ALLPICS' => append_sid(album_append_uid('album_allpics.' . $phpEx)),
		'U_ALBUM_OTF' => append_sid(album_append_uid('album_otf.' . $phpEx)),
		)
	);
}
// it's a personal gallery, and in the root folder
else
{
	if ($album_view_mode == ALBUM_VIEW_LIST)
	{
		include ($album_root_path . 'album_memberlist.' . $phpEx);
	}
	else
	{
		// include our special personal gallery files
		// this file holds all the code to handle personal galleries
		// except moderation and management of personal gallery categories.
		include ($album_root_path . 'album_personal.' . $phpEx);
	}
}

if (empty($album_view_mode))
{
	album_display_index($album_user_id, ALBUM_ROOT_CATEGORY, true, true, true);
}

// Generate the page
$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.' . $phpEx);

?>